<?php get_header() ?>

<?php 
if(have_rows('frontpage_slides')):
	include('modules/frontpage-slider.php');
endif;
?>	


<!-- ABOUT -->
<section class="module reveal--up about" id="about">

	<div class="wrapper">

		<header class="module__header">
			<h2 class="module__title"><?php the_field('frontpage_objectives_title') ?></h2>
			<div class="module__intro">
				<?php the_field('frontpage_objectives_excerpt') ?>
			</div>
			<a href="<?php the_field('frontpage_objectives_link') ?>" class="module__read-further">Ver mas <span class="icon-chevron-small-right"></span></a>
		</header>

		<div class="about__grid">

			<?php 

				$fc = get_field('frontpage_objectives_first_column');
				$sc = get_field('frontpage_objectives_second_column');

			?>

			<article class="about__item">
				<div class="about__image">
					<span class="icon-<?php echo $fc['icon'] ?>"></span>
				</div>
				<div class="about__body">
					<h3 class="about__title"><?php echo $fc['title'] ?></h3>
					<div class="about__text">
						<?php echo $fc['text'] ?>
					</div>
				</div>
			</article>
					
			<article class="about__item">
				<div class="about__image">
					<span class="icon-<?php echo $sc['icon'] ?>"></span>
				</div>
				<div class="about__body">
					<h3 class="about__title"><?php echo $sc['title'] ?></h3>
					<div class="about__text">
						<?php echo $sc['text'] ?>
					</div>
				</div>

				
			</article>
		</div>

	</div>
</section>

<!-- PROJECTS -->
<section class="module module--bg-gray reveal--up" id="projects">
	<div class="wrapper">

		<header class="module__header">
			<h2 class="module__title"><?php the_field('frontpage_projects_title') ?></h2>
			<a href="<?php the_field('frontpage_projects_link') ?>" class="module__read-further">Ver mas <span class="icon-chevron-small-right"></span></a>
		</header>

		<div class="projects__grid">
			
			<div class="projects__content">
				<span class="projects__title"><?php the_field('frontpage_projects_subtitle') ?></span>
				<div class="projects__excerpt"><?php the_field('frontpage_projects_excerpt') ?></div>
				<a href="<?php the_field('frontpage_projects_link') ?>" class="projects__link">Ver todos <span class="icon-chevron-small-right"></a>
			</div>
			
			<?php 

				$featured = get_field('featured_projects');

				$args = array(
					'post_type' => 'project',
					'posts_per_page' => 3,
					'post__in'	=> $featured,
					'orderby'	=> 'post__in',
					// 'orderby'	=> 'meta_value_num',
					// 'meta_key'	=> 'project_state_start_year'
				);

				$query = new WP_Query($args);

				if($query->have_posts()): 
					while($query->have_posts()): 
						$query->the_post();

						include('modules/excerpt-project.php');

					endwhile; 
				endif;
				wp_reset_postdata() ?>

		</div>
	</div>
</section>


<!-- ACTIVITIES -->
<section class="module reveal--up frontpage-activities" id="activities">
	
	<div class="wrapper">

		<header class="module__header">
			<h2 class="module__title"><?php the_field('frontpage_activities_title') ?></h2>
			<a href="<?php the_field('frontpage_activities_link') ?>" class="module__read-further">Ver todas <span class="icon-chevron-small-right"></span></a>
		</header>

	<?php 

		$args = array(
			'post_type' => array('congress','training','activity'),
			'posts_per_page' => 4,
		);

		$query = new WP_Query($args);

		if( $query->have_posts() ):
	?>


		<div class="grid grid--3-cols grid--frontpage-activities">
			<?php 

			while( $query->have_posts()): 
				$query->the_post(); 
				include('modules/excerpt-activity.php');
			endwhile; 

			?>
		</div>	

	<?php else: ?>
		<div class="module module--gray module--with-grid">
			<div class="wrapper">
				<p class="no-results">No se han encontrado actividades</p>
			</div>
		</div>

	<?php 
		endif;
		wp_reset_postdata();
	?>
	</div>
</section>

<?php get_footer() ?>