<?php 

// Obtiene todos los posts del CPT Publicaciones y los ordena por tipos
function get_all_publications(){
	$args = array(
		'post_type'	=> 'publication',
		'posts_per_page' => -1,
	);

	$query = get_posts($args);
	$publications = array();

	foreach($query as $q): 

			// No tiene coste extra (las taxonomías si: 1 extra por post)
			$type = get_post_meta( $q->ID, 'type', true );

			if(!$type){
				$type = null;
			}

			switch ($type) {
	    		case 'Producción académica':
	    			$field = get_post_meta( $q->ID, "academic_production_fields", true);
	    			break;
	    		case 'Artículos científicos':
	    			$field = get_post_meta( $q->ID, "scientific_articles_fields", true);
	    			break;
	    		case 'Series CEDI':
	    			$field = get_post_meta( $q->ID, "cedi_series_fields", true);
	    			break;
	    	}

			$publications[$type][$field][] = $q; 
	endforeach;

	wp_reset_postdata();

	return $publications;
}


// Añade columnas extra a la página de publication
function cedi_publication_columns_add( $columns ) {

  $columns = array(
    'cb'			=> '<input type="checkbox" />',
    'title'			=> 'Título',
    'type'			=> 'Tipo',
    'subtype'		=> 'Subtipo'
  );
  return $columns;
}

function cedi_publication_columns_content( $column ) {

  global $post;

  switch ( $column ) {
    case 'type':
      	echo get_field( "type", $post->ID );
      	break;
    case 'subtype':
    	$type = get_field( "type", $post->ID );
    	switch ($type) {
    		case 'Producción académica':
    			echo get_field( "academic_production_fields", $post->ID );
    			break;
    		case 'Artículos científicos':
    			echo get_field( "scientific_articles_fields", $post->ID );
    			break;
    		case 'Series CEDI':
    			echo get_field( "cedi_series_fields", $post->ID );
    			break;
    	}
  }

}

function cedi_publication_columns_sort( $columns ){
	$columns['type'] = 'type';
	$columns['subtype'] = 'subtype';
	return $columns;
}


add_filter('manage_edit-publication_columns' , 'cedi_publication_columns_add');
add_action('manage_publication_posts_custom_column', 'cedi_publication_columns_content', 10, 2 );
add_filter("manage_edit-publication_sortable_columns", "cedi_publication_columns_sort" );

?>