<?php


// include('functions-acf-fields.php');

/************************************************

CREACION MENUS DASHBOARD

*************************************************/

function cedi_options(){
	acf_add_options_page(array(
		'page_title' 	=> 'Opciones generales',
		'menu_title'	=> 'Opciones generales',
		'menu_slug' 	=> 'theme-general-settings',
		'capability'	=> 'edit_posts',
		'position' 		=> '40.5',
	));

	acf_add_options_sub_page(array(
		'page_title' 	=> 'Generales',
		'menu_title'	=> 'Generales',
		'parent_slug'	=> 'theme-general-settings',
	));
}

if( function_exists('acf_add_options_page')){
	cedi_options();
}






/************************************************

ENCOLAMIENTO

*************************************************/


function cedi_styles_and_scripts() {

	if(!is_admin()){
		wp_deregister_script( 'jquery' );
		wp_register_script('jquery', "//ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js", false, null);
   		wp_enqueue_script('jquery');
	}


	wp_enqueue_style( 'wpb-google-fonts', 'http://fonts.googleapis.com/css?family=Raleway:300,400,500,600,700,800,900|Source+Sans+Pro:300,400,600,700', false );
	wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/js/modernizr.min.js', array(), null, false );
    wp_enqueue_style( 'style', get_stylesheet_uri() );

    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), null, true );
    //wp_enqueue_script( 'scroll-reveal', get_template_directory_uri() . '/js/scrollreveal.min.js', array('jquery'), null, false );

    //wp_enqueue_script( 'google-map', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDhs4m1FVTlGW_VGa1ZccMLIAK_3wxOoSQ', array(), '3', true );
    wp_enqueue_script( 'app', get_template_directory_uri() . '/js/app.min.js', array(), null, true );
}
add_action( 'wp_enqueue_scripts', 'cedi_styles_and_scripts' );






/************************************************

MENUS

*************************************************/

register_nav_menus( array(
	'header_menu' 		=> 'Menu de cabecera',
	'footer_menu' 		=> 'Menú del footer',
	'activities_menu'	=> 'Submenú de actividades',
	'publishing_menu'	=> 'Submenú de publicaciones'
) );

// Cargaremos en ella el menu para imprimirlo en dos sitios
$menu = null;


function jm_menu_classes($classes, $item, $args) {

	if( $args->theme_location == 'activities_menu') {
	$classes[] = 'filter';
	}else if( $args->theme_location == 'publishing_menu' ){
		$classes[] = 'pub-filters__filter';
	}else{
		return $classes;
	}

	$pos = array_search('menu-item', $classes);
    unset( $classes[$pos] );

	return $classes;
}
add_filter('nav_menu_css_class', 'jm_menu_classes', 1, 3);

// Shortcodes de formulario
add_filter('acf/format_value/type=textarea', 'do_shortcode');
add_filter('acf/format_value/type=text', 'do_shortcode');
add_filter('wpcf7_autop_or_not', '__return_false');






// EXTRACTOS
function jm_excerpt_length( $length ) {
	return 15;
}
add_filter( 'excerpt_length', 'jm_excerpt_length', 999 );




// IMAGENES
add_theme_support( 'post-thumbnails' );
add_image_size('thumbnail_2x', 900, 408, true);

// Proyectos
add_image_size( 'vertical', 330, 450, true );
add_image_size( 'vertical_2x', 660, 900, true );

// Equipo
add_image_size( 'team', 340, 340, true );



// Funciones propias


function jm_print_button($id){
	$button_type = get_post_meta($id, 'button_type', true);
	$target = null;

	switch( $button_type ){
		case 'external' :
			$url = get_post_meta($id, 'button_url', true);
			$target = 'target="_blank"';
			$icon = 'icon-external-link';
			break;
		case 'internal' :
			$url = get_permalink( get_post_meta($id, 'button_url', true) );
			$icon = 'icon-link';
			break;
		case 'document' :
			$url = get_post_meta($id, 'button_url', true);
			$target = 'target="_blank"';
			$icon = 'icon-file-pdf-o';
			break;
	}

	$link = '<a href="' . $url . '" '. $target .' class="read-further__link">';

	if($icon){
		$link .= '<span class="'. $icon .'"></span>';
	}

	$link .= get_post_meta($id, 'button_text', true);
	$link .= '</a>';

	echo $link;
}

function jm_get_page_title(){

	$page_info = array(
		'title' => null,
		'description' => null
	);

	$page_id = get_the_ID();

	$page_info['title'] = get_post_meta($page_id,'page_title',true);
	$page_info['description'] = get_post_meta($page_id,'page_description',true);

	if( $page_info['title'] ){
		return $page_info;
	}

	$cpt = get_post_type($page_id);

	switch($cpt){
		case 'activity': $page_id = 10; break;
		case 'scientific_pub': $page_id = 538; break;
		case 'academic_pub': $page_id = 536; break;
		case 'cedi_series': $page_id = 540; break;
		case 'congress': $page_id = 438; break;
		case 'training': $page_id = 440; break;
		case 'award': $page_id = 265; break;
		case 'project': $page_id = 263; break;
		case 'team': $page_id = 608; break;
	}

	$page_info['title'] = get_post_meta($page_id,'page_title',true);
	$page_info['description'] = get_post_meta($page_id,'page_description',true);

	return $page_info;
}

// Admin columns

/*
 * Add columns to exhibition post list
 */
function add_scientific_columns ( $columns ) {
   return array_merge ( $columns, array ( 
     'year' => __ ( 'Año' )
   ) );
 }
add_filter ( 'manage_scientific_pub_posts_columns', 'add_scientific_columns' );

function add_academic_columns ( $columns ) {
   return array_merge ( $columns, array ( 
     'year' => __ ( 'Año' )
   ) );
 }
add_filter ( 'manage_academic_pub_posts_columns', 'add_academic_columns' );

function add_cedi_columns ( $columns ) {
   return array_merge ( $columns, array ( 
     'year' => __ ( 'Año' )
   ) );
 }
add_filter ( 'manage_cedi_series_posts_columns', 'add_cedi_columns' );

function scientific_pub_column ( $column, $post_id ) {
	switch($column){
		case 'year' : echo get_post_meta ( $post_id, 'year', true ); break;
	}   
 }
add_action ( 'manage_scientific_pub_posts_custom_column', 'scientific_pub_column', 10, 2 );

function academic_pub_column ( $column, $post_id ) {
	switch($column){
		case 'year' : echo get_post_meta ( $post_id, 'year', true ); break;
	}   
 }
add_action ( 'manage_academic_pub_posts_custom_column', 'academic_pub_column', 10, 2 );

function cedi_series_column ( $column, $post_id ) {
	switch($column){
		case 'year' : echo get_post_meta ( $post_id, 'year', true ); break;
	}   
 }
add_action ( 'manage_cedi_series_posts_custom_column', 'cedi_series_column', 10, 2 );

add_filter('manage_posts_columns', 'cedi_pub_column_order');
function cedi_pub_column_order($columns) {
  $n_columns = array();
  $move = 'year'; // what to move
  $before = 'date'; // move before this
  foreach($columns as $key => $value) {
    if ($key==$before){
      $n_columns[$move] = $move;
    }
      $n_columns[$key] = $value;
  }
  return $n_columns;
}


add_filter( 'manage_edit-cedi_series_sortable_columns', 'cedi_series_sortable_columns');
function cedi_series_sortable_columns( $columns ) {
  $columns['year'] = 'year';
  return $columns;
}

add_filter( 'manage_edit-scientific_pub_sortable_columns', 'scientific_pub_sortable_columns');
function scientific_pub_sortable_columns( $columns ) {
  $columns['year'] = 'year';
  return $columns;
}

add_filter( 'manage_edit-academic_pub_sortable_columns', 'academic_pub_sortable_columns');
function academic_pub_sortable_columns( $columns ) {
  $columns['year'] = 'year';
  return $columns;
}

add_action( 'pre_get_posts', 'cedi_posts_orderby' );
function cedi_posts_orderby( $query ) {
  if( ! is_admin() || ! $query->is_main_query() ) {
    return;
  }

  if ( 'year' === $query->get( 'orderby') ) {
    $query->set( 'orderby', 'meta_value' );
    $query->set( 'meta_key', 'year' );
    $query->set( 'meta_type', 'numeric' );
  }
}
?>
