<!DOCTYPE html>
<html lang="<?php bloginfo('language') ?>" class="no-js">
<head>
	<meta charset="<?php bloginfo('charset') ?>">
	<meta name="viewport" content="width=device-width">
	<title><?php bloginfo('name') ?></title>

<!-- <script src="js/scrollreveal.min.js"></script> -->
	
	<script src="https://unpkg.com/scrollreveal"></script>
	<script>
		ScrollReveal({ duration: 1000 })
	</script>
	<!-- <link rel="stylesheet" href="https://i.icomoon.io/public/4093824b54/CEDI/style.css"> -->
	<!-- <link href="https://fonts.googleapis.com/css?family=Raleway:300,400,500,600,700,800,900|Source+Sans+Pro:300,400,600,700" rel="stylesheet"> -->

	<?php wp_head() ?>
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-146573988-1"></script>
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());

		gtag('config', 'UA-146573988-1');
	</script>
</head>
<body>

<div class="ios-canvas">
<div class="page-canvas">

	<header class="site-header">

		<section class="site-header__masthead">
			<div class="wrapper">
				<div class="site-header__logo">
					<div class="logo logo--completo"><a href="<?php bloginfo('url') ?>"><?php bloginfo('name') ?></a></div>
				</div>

				<div class="site-header__btn-menu">
					<a href="#footer" class="btn-menu"><span class="icon-menu"></span></a>
				</div>

				<nav class="site-header__menu">
					<?php 
						global $menu;

						$menu = wp_nav_menu(array(
								'container' => false,
								'depth'		=> 2,
								'theme_location'	=> 'header_menu',
								'echo'				=> false
							)
						);

						echo $menu
					?>
				</nav>
			</div>
		</section>

		<section class="site-header__topbar">
			<div class="wrapper">
				<div class="site-header__social">
					<?php if(have_rows('rrss','option')): ?>
					<nav class="social">
						<?php while(have_rows('rrss','option')): the_row() ?>
							<a target="_blank" href="<?php the_sub_field('rrss_url') ?>" class="social__item social__item--sh"><span class="icon-<?php the_sub_field('rrss_icon') ?>"></span></a>
						<?php endwhile ?>
					</nav>
					<?php endif ?>
				</div>
			</div>
		</section>
	</header>


	<!-- TITULO DE PÁGINA -->
	<?php 
		if( !is_front_page() ): 
			include('modules/page-title.php');
		endif;
	?>








