<?php $id =  get_the_id(); ?>
<article class="activity">
	<h3 class="activity__title"><?php the_title() ?></h3>

	<?php 
		if(has_post_thumbnail( $id )): 
			the_post_thumbnail('post-thumbnail', array('class'=>'activity__image'));
		else:
			echo wp_get_attachment_image( 491, 'thumbnail', false, array('class'=>"activity__image") );
		endif;
	?>
	
	<div class="activity__content">
		<div class="activity__metadata-container">
			
			<?php if( $act_type = get_post_meta( $id, 'activity_type', false ) ): ?>
				<p class="activity__metadata">
					<span class="icon-tag"></span>
					<?php echo $act_type[0] ?>
				</p>
			<?php endif; ?>

			<?php if( $act_year = get_post_meta( $id, 'activity_date', true ) ): ?>
				<p class="activity__metadata">
					<span class="icon-calendar"></span>
					<?php echo date_i18n( 'F Y', strtotime( $act_year ) ); ?>
				</p>
			<?php endif; ?>

			<?php if( $congress_place = get_post_meta( $id, 'activity_place', true ) ): ?>
				<p class="activity__metadata">
					<span class="icon-location"></span>
					<?php echo $congress_place ?>
				</p>
			<?php endif; ?>

		</div>
		<div class="activity__excerpt">
			<?php the_excerpt() ?>
		</div>
	</div>
	<a class="activity__link" href="<?php the_permalink() ?>">Ver actividad <span class="icon-arrow-right"></span></a>
</article>