<?php 

// Datos del proyecto
$post_id = get_the_ID();

// project_title_firstline y project_title_secondline
$project_title_firstline   = get_post_meta( $post_id, 'project_title_firstline', true );
$project_title_secondline   = get_post_meta( $post_id, 'project_title_secondline', true );

// project_image
$class = has_post_thumbnail() ? 'project--has-image' : 'project--has-no-image';

// project_state_active, project_state_start_year, project_state_end_year

if(get_post_meta( $post_id, 'project_state_active', true ) == '1' || !get_post_meta($post_id,'project_state_end_year', true) ){
	$active = 'activo';
}else{
	$active = 'finalizado';
}

$start_year = get_post_meta( $post_id, 'project_state_start_year', true );
$end_year = get_post_meta( $post_id, 'project_state_end_year', true );

?>
<article class="project <?php echo $class; ?>" data-status="<?php echo $active ?>">
	
	<?php if($active == 'activo'): ?>
		<span class="project-is-active"><span class="icon-update"></span></span>
	<?php endif; ?>

	<div class="project__content">
		<h3 class="project__title">
			<span><?php echo $project_title_firstline ?></span>
			<?php echo $project_title_secondline ?>
		</h3>
		<div class="project__texts">

			<ul class="project__excerpt">
				<li><strong>Estado:</strong> <?php echo $active ?></li>

				<?php if($start_year): ?>
					<li><strong>Inicio del proyecto:</strong> <?php echo $start_year ?></li>
				<?php endif; ?>
				<?php if($end_year): ?>
					<li><strong>Fin del proyecto:</strong> <?php echo $end_year ?></li>
				<?php endif; ?>
			</ul>

			
			<a href="<?php the_permalink() ?>" class="project__link">
				Ver proyecto <span class="icon-arrow-right"></span>
			</a>
		</div>
	</div>

	<span class="project__title"><span><?php echo $project_title_firstline ?></span><?php echo $project_title_secondline ?></span>

	<?php
		if( has_post_thumbnail() ){
			the_post_thumbnail('vertical', array('class'=>'project__image'));
		}
	?>

</article>