<?php

get_header();
$id = get_the_ID();

?>

<!-- OBJETIVOS -->
<section class="module">
	<article class="alliance">

			<div class="wrapper wrapper--text">
				<header class="module__header">
					<h2 class="module__title"><?php echo get_post_meta($id,'section_title',true); ?></h2>
				</header>
			</div>

			<div class="wrapper wrapper--alliance">
				<div class="alliance__content">
					<div class="alliance__images">
						<?php 

							$image_1_id = get_post_meta($id,'section_images_image_1',true);
							$image_2_id = get_post_meta($id,'section_images_image_2',true);


							echo wp_get_attachment_image( $image_1_id, 'vertical_2x', false, array('class'=>"alliance__image") );
							echo wp_get_attachment_image( $image_2_id, 'vertical_2x', false, array('class'=>"alliance__image") );
						?>
					</div>
					<div class="alliance__texts">
						<?php the_field('section_text'); ?>
					</div>
				</div>
			</div>
		
			<?php if(have_rows('partners')): ?>
			<div class="wrapper">
				<div class="partners__container">
					<?php 
						while(have_rows('partners')): 
							the_row();
							$partner_logo = get_sub_field('partner_logo');
							$partner_name = get_sub_field('partner_name');
					?>
						<img src="<?php echo wp_get_attachment_url( $partner_logo ) ?>" alt="<?php echo $partner_name ?>" class="partner__logo">
					<?php 
						endwhile;
					?>
				</div>
			</div>
			<?php endif; ?>


	</article>
</section>


<!-- ÁREAS DE TRABAJO -->
<?php
if(have_rows('fields')):
?>
<section class="module module--bg-gray reveal--up">
	<article class="fields">
		
		<div class="wrapper">
			<header class="module__header">
				<h2 class="module__title"><?php echo get_post_meta($id,'fields_title',true); ?></h2>
			</header>
		</div>

		<div class="wrapper wrapper--medium">
			<div class="fields__container">
				<?php 
					while(have_rows('fields')):
						the_row();
				?>
				<article class="field">
					<div class="field__icon">
						<span class="<?php the_sub_field('farea_icon') ?>"></span>
					</div>
					<div class="field__content">
						<h3 class="field__title"><?php the_sub_field('farea_title') ?></h3>
						<div class="field__excerpt">
							<p><?php the_sub_field('farea_excerpt') ?></p>
						</div>
						
						<a href="<?php the_sub_field('farea_link') ?>" class="field__link"><?php the_sub_field('farea_link_text') ?> <span class="icon-chevron-small-right"></span></a>
					</div>
				</article>
				<?php 
					endwhile;
				?>
			</div>
		</div>

	</article>
</section>
<?php endif; ?>


<!-- EQUIPO -->
<?php 

$args = array(
	'post_type' => 'team',
	'posts_per_page' => -1,
	'orderby' => 'menu_order',
	'order'		=> 'ASC'
);

// Order ASC

$q = new WP_Query($args);

if($q->have_posts()):
?>

<section class="module reveal--up team">
	<div class="wrapper">
		<header class="module__header">
			<h2 class="module__title"><?php echo get_post_meta($id,'team_title',true); ?></h2>
		</header>
	</div>

	<div class="wrapper">
		<div class="team__container">
			<?php while($q->have_posts()): $q->the_post() ?>
			<a href="<?php the_permalink() ?>" class="team__member">
				<?php the_post_thumbnail( 'team', array('class'=>'team__image')) ?>
				<div class="team__content">
					<h3 class="team__title"><?php the_title() ?></h3>
					<p class="team__position"><?php echo get_post_meta(get_the_id(),'staff_position',true); ?></p>
				</div>
			</a>
			<?php endwhile; ?>
		</div>
	</div>
</section>

<?php endif; wp_reset_postdata() ?>


<!-- COLABORADORES -->
<!-- <?php
if(have_rows('collaborators')):
?>
<div class="module reveal--up">
	<article class="collaboration">
		<div class="wrapper">
			<header class="module__header">
				<h2 class="module__title"><?php echo get_post_meta($id,'collaborators_title',true); ?></h2>
			</header>
			<div class="collaboration__container">
				<?php 
					while(have_rows('collaborators')):
						the_row();
				?>
					<a href="<?php the_sub_field('collaborator_url') ?>" class="collaboration__link" target="_blank">
						<img src="<?php the_sub_field('collaborator_logo') ?>" alt="<?php the_sub_field('collaborator_name') ?>" class="collaboration__image">
					</a>
				<?php 
					endwhile;
				?>
			</div>
		</div>
	</article>
</div>
<?php endif; ?> -->

<?php get_footer() ?>