<?php get_header() ?>

<?php 

	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

	$temp = $wp_query;
	$wp_query = null;

	$args = array(
		'paged'			=> $paged,
		'post_type' 	=> 'award',
		'posts_per_page'=> 10,

		'meta_query' => array(
			'relation' => 'OR',
			array( // Recupera posts si el año existe
		        'key' => 'year',
		        'type'=> 'numeric',
		        'compare' => 'EXISTS',
		    ),
		  	array( // Recupera posts si el año no existe
		        'key' => 'year',
		        'value' => '',
		        'compare' => 'NOT EXISTS'
		    )
		),
		'orderby' => array( 'meta_value_num' => 'DESC', 'title' => 'ASC' ),
	);

	$wp_query = new WP_Query($args);

	if( $wp_query->have_posts() ):

		$id =  get_the_id();
?>
<div class="module module--gray awards">
	<div class="wrapper">
		<div class="grid grid--awards">
				
			<?php 
				while( $wp_query->have_posts()): 
					$wp_query->the_post();
					include('modules/excerpt-award.php');
				endwhile; 
			?>

		</div>	
	</div>
</div>
<div class="module module--navigation">
	<div class="wrapper">
		<?php wp_pagenavi() ?>
	</div>
</div>
<?php 
	else:
?>
<div class="module module--gray module--with-grid">
	<div class="wrapper">
		<p class="no-results">No se han encontrado elementos</p>
	</div>
</div>
<?php 
	endif;
	wp_reset_postdata();
	$wp_query = null;
	$wp_query = $temp;
?>

<?php get_footer() ?>