<?php 

get_header();

$id = get_the_ID();

if( get_post_meta($id,'has_video',true) == '1' ){
	include 'modules/video.php';
}

?>

<div class="page-filter-container">
	<div class="wrapper">
		<ul class="filters filters--projects">
			<li class="filter filter--projects current-menu-item"><a href="#" data-target="todos">Todos</a></li>
			<li class="filter filter--projects"><a href="#" data-target="activo">Activos</a></li>
			<li class="filter filter--projects"><a href="#" data-target="finalizado">Finalizados</a></li>
		</ul>
	</div>
</div>

<?php 
	$args = array(
		'post_type' => 'project',
		'posts_per_page' => -1,
		'orderby'	=> array( 'meta_value_num' => 'DESC', 'title' => 'ASC' ),
		'meta_key'	=> 'project_state_start_year',
		// 'paged' => $paged
	);

	$wp_query = new WP_Query($args);

	if( $wp_query->have_posts() ):
?>

<div class="module module--gray module--with-grid projects">
	<div class="wrapper">
		
		<div class="grid grid--4-cols grid--projects">
			
			<?php 

			while( $wp_query->have_posts()): 
				$wp_query->the_post(); 
				include('modules/excerpt-project.php');
			endwhile; 

			?>
			
		</div>
	</div>
</div>
<?php else: ?>
<div class="module module--gray module--with-grid">
	<div class="wrapper">
		<p class="no-results">No se han encontrado proyectos</p>
	</div>
</div>

<?php 
	endif;
	wp_reset_postdata();

get_footer() ?>