<?php 
/*
Template Name: Eventos
*/


get_header();

$submenu = wp_nav_menu(array(
		'container' => false,
		'menu_class'		=> 'filters',
		'depth'		=> 1,
		'theme_location'	=> 'activities_menu',
		'echo'				=> false
	)
);

?>
<div class="page-filter-container">
	<div class="wrapper">
		<?php echo $submenu; ?>
	</div>
</div>


<?php 

	if( is_page(438) ){
		$post_type = 'congress';
	}else if( is_page(440) ){
		$post_type = 'training';
	}else if( is_page(10) ){
		$post_type = 'activity';
	}else{
		$post_type = array('activity', 'training', 'congress');
	}

	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

	$temp = $wp_query;
	$wp_query = null;

	$args = array(
		'post_type' => $post_type,
		'posts_per_page' => 9,
		'paged' => $paged
	);



	if( $post_type == 'training' ){
		$args['meta_query'] = array(
			'relation' => 'OR',
			array( 
		        'key' => 'activity_date',
		        'type'=> date('j-m-Y'),
		        'compare' => 'EXISTS',
		    ),
		    array( // Recupera posts si el año no existe
		        'key' => 'activity_date',
		        'value' => '',
		        'compare' => 'NOT EXISTS'
		    )
		);
		$args['orderby'] = array( 'meta_value' => 'DESC', 'title' => 'ASC' );
	}







	$wp_query = new WP_Query($args);

	if( $wp_query->have_posts() ):
?>
<div class="module module--gray module--with-grid">
	<div class="wrapper">
		<div class="grid grid--3-cols">
			
			<?php 

			while( $wp_query->have_posts()): 
				$wp_query->the_post(); 
				include('modules/excerpt-activity.php');
			endwhile; 

			?>
			
		</div>
	</div>
</div>
<div class="module module--navigation">
	<div class="wrapper">
		<?php wp_pagenavi() ?>
	</div>
</div>

<?php else: ?>
<div class="module module--gray module--with-grid">
	<div class="wrapper">
		<p class="no-results">No se han encontrado elementos</p>
	</div>
</div>

<?php 
	endif;
	wp_reset_postdata();
	$wp_query = null;
	$wp_query = $temp;
?>

<?php get_footer() ?>