<?php 
/*
Template Name: Publicaciones
*/

get_header();

// Submenú filtros
$submenu = wp_nav_menu(array(
		'container' 		=> false,
		'menu_class'		=> 'pub-filters__menu',
		'depth'				=> 1,
		'theme_location'	=> 'publishing_menu',
		'echo'				=> false
	)
);

// Query

if( is_page(536) ){
	$post_type = 'academic_pub';
}else if( is_page(538) ){
	$post_type = 'scientific_pub';
}else if( is_page(540) ){
	$post_type = 'cedi_series';
}else{
	$post_type = array('academic_pub','scientific_pub', 'cedi_series');
}

$main_section = null;
$section = null;

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$temp = $wp_query;
$wp_query = null;

/*$args = array(
	'paged' => $paged,
	'post_type' => $post_type,
	'posts_per_page' => -1,
	'meta_key' => 'fields',
	'orderby' => array(
		'type' => 'ASC',
		'meta_value' => 'ASC',
		'menu_order' => 'ASC'
	)
);*/

$args = array(
	'paged'				=> $paged,
	'post_type' 		=> $post_type,
	'posts_per_page'	=> 9,
	'meta_query'		=> array(
		'relation'		=> 'AND',
		'fields_clause'	=> array(
			'key'	=> 'fields',
			'compare'	=> 'EXISTS',
		),
		'year_clause'	=> array(
			'key'	=> 'year',
			'type'	=> 'numeric',
			'compare'	=> 'EXISTS',
		),
	),
	'orderby'		=> array(
		'type'			=> 'ASC',
		'fields_clause' => 'ASC',
		'year_clause'	=> 'DESC'
	)
);

$wp_query = new WP_Query($args);

?>

<div class="module publishing">
	<div class="wrapper">
		<div class="publishing__grid">

			<aside class="pub-aside">
				<div class="pub-aside__container">
					<h2 class="pub-aside__title">Filtros</h2>
					<nav class="pub-aside__nav">
						<?php echo $submenu ?>					
					</nav>
				</div>

				<?php if($post_type == 'cedi_series'): ?>
					<div class="pub-aside__container">
						<h2 class="pub-aside__title">Pedidos</h2>
						<p><?php echo get_option('options_cedi_text', false); ?></p>
						<a href="mailto:<?php echo get_option('options_cedi_email', false); ?>"><?php echo get_option('options_cedi_email', true); ?></a>
					</div>
				<?php endif; ?>

			</aside>

			<?php if( $wp_query->have_posts() ): ?>
			<div class="publishing__subgrid">

					<?php include('modules/publication.php') ?>

			</div>
			<?php else: ?>
				<p class="no-results">No se han encontrado elementos</p>
			<?php endif; ?>


			<div class="publishing__grid--full-row">
				<div class="module module--navigation">
						<?php wp_pagenavi() ?>
				</div>
			</div>
			<?php wp_reset_postdata() ?>
		</div>
	</div>
</div>

<?php get_footer() ?>