<?php

get_header();

if(have_posts()):
	while(have_posts()):
		the_post();
		$id = get_the_ID();
		$post_type = get_post_type(  );

		if($post_type == 'training' || $post_type == 'congress'){
			$post_type = 'activity';
		}
?>

		<article class="module module--single">			
			<div class="single__title-container">
				<div class="wrapper wrapper--text">
					<h1 class="single__title"><?php the_title() ?></h1>
				</div>
			</div>
			<div class="wrapper">
				<div class="grid grid--2-cols grid--single">
					<figure class="single__image-container single__image-container--<?php echo $post_type ?>">

						<?php 

							if(has_post_thumbnail( $id )): 
								the_post_thumbnail('post-thumbnail', array('class'=>'single__featured-image' ));
							else:
								echo wp_get_attachment_image( 491, 'thumbnail', false, array('class'=>"single__featured-image") );
							endif;
						?>
						
						<?php if(file_exists(get_template_directory() . '/modules/metadata-' . $post_type . '.php')): ?>
						<figcaption>
							
							<?php include(get_template_directory() . '/modules/metadata-' . $post_type . '.php'); ?>

						</figcaption>
						<?php endif; ?>

					</figure>
		
					<div class="single__content-container">
						<?php the_content() ?>

						<?php if( get_post_meta($id, 'has_button', true) == '1' ): ?>
						<div class="read-further">

							<?php jm_print_button($id); ?>

						</div>
						<?php endif; ?>
					</div>

					
				</div>
			</div>
		</article>

<?php 

	endwhile;
endif; 

get_footer();

?>